/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.ethernet;

import ibm.nways.ethernet.model.RptrRptrInfoScalarsModel;
import ibm.nways.jdm.I18NGiblets;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;

public class ActionEthernetRepeater
implements StatusMapper {
    private static String enumBundle = "ibm.nways.ethernet.eui.EnumeratedResources";
    private static String bundleName = "ibm.nways.ethernet.Resources";
    private boolean loggingOn = false;

    public ActionEthernetRepeater() {
        String string = JdmServerImpl.getProperty("startLogging");
        if (string != null && string.equals("yes")) {
            this.loggingOn = true;
        }
    }

    public void calculateStatus(StatusModelInfo statusModelInfo, StatusModelInfo statusModelInfo2) {
        try {
            if (this.loggingOn) {
                System.out.println("ActionEthernetRepeater");
                System.out.println("rptrOperStatus = " + statusModelInfo.get("Panel.RptrOperStatus"));
            }
            StatusAndExplain statusAndExplain = this.evaluateStatus((Integer)statusModelInfo.get("Panel.RptrOperStatus"));
            statusModelInfo.setStatusType(statusAndExplain.statType, statusAndExplain.explain, true);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public I18NString nameThatObject(StatusModelInfo statusModelInfo) {
        I18NString i18NString = new I18NString(bundleName, "STATUS_NAME_REPEATER");
        return i18NString;
    }

    private StatusAndExplain evaluateStatus(int n) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        Object[] objectArray = new Object[1];
        switch (n) {
            case 2: {
                statusAndExplain.statType = StatusType.NORMAL;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                statusAndExplain.statType = StatusType.CRITICAL;
                break;
            }
            default: {
                statusAndExplain.statType = StatusType.UNKNOWN;
            }
        }
        try {
            objectArray[0] = new I18NString(enumBundle, RptrRptrInfoScalarsModel.Panel.RptrOperStatusEnum.numericToSymbolic(n));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            objectArray[0] = new I18NString(bundleName, "UNEXPECTED_RPTR_STATUS");
        }
        statusAndExplain.explain = new I18NGiblets(bundleName, "RPTR_STATUS_TEXT", objectArray);
        if (this.loggingOn) {
            System.out.println("ret.statType = " + statusAndExplain.statType);
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (objectArray[n2] instanceof I18NString) {
                    System.out.println("arg[" + n2 + "]  bundleName = " + ((I18NString)objectArray[n2]).getBundleName());
                    System.out.println("arg[" + n2 + "]  key  = " + ((I18NString)objectArray[n2]).getKey());
                } else {
                    System.out.println("arg[" + n2 + "] = " + objectArray[n2].toString());
                }
                ++n2;
            }
            System.out.println("ret.explain = " + statusAndExplain.explain.getTranslation());
        }
        return statusAndExplain;
    }

    private class StatusAndExplain {
        StatusType statType;
        I18NGiblets explain;

        StatusAndExplain() {
            ActionEthernetRepeater.this = ActionEthernetRepeater.this;
        }
    }
}

